from django.shortcuts import render, redirect
from django.contrib import messages
from django.core.mail import EmailMessage
from django.conf import settings
from .forms import ContactMessageForm
from .models import ContactMessage  # ✅ Import your model

def contact_view(request):
    if request.method == 'POST':
        form = ContactMessageForm(request.POST)
        if form.is_valid():
            # ✅ Save form data to the database
            contact_message = form.save()

            # Build the email body
            body = (
                f"Name: {contact_message.name}\n"
                f"Email: {contact_message.email}\n"
                f"Subject: {contact_message.subject}\n"
                f"Message:\n{contact_message.message}"
            )

            # ✅ Send email to site admin (you)
            email_msg = EmailMessage(
                subject=contact_message.subject,
                body=body,
                from_email=settings.EMAIL_HOST_USER,
                to=[settings.EMAIL_HOST_USER],  # Admin receives the email
                reply_to=[contact_message.email],  # Replies go to the sender
            )

            try:
                email_msg.send(fail_silently=False)
                messages.success(request, "Your message has been sent successfully!")
            except Exception as e:
                messages.error(request, f"Error sending email: {e}")

            # Redirect to the same page after successful submission
            return redirect('contact')

    else:
        form = ContactMessageForm()

    # Render the contact form page
    return render(request, 'contact.html', {'form': form})
